/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.mixin.MekMixin;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.content.gear.mekasuit.ModuleSolarRechargingUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(remap=false, value={ModuleSolarRechargingUnit.class})
public class ModuleSolarRechargingUnitMixin {
    @Final
    @Shadow
    private static FloatingLong RAIN_MULTIPLIER;

    @Overwrite
    public void tickServer(IModule<ModuleSolarRechargingUnit> module, Player player) {
        BlockPos pos;
        IEnergyContainer energyContainer = module.getEnergyContainer();
        if (energyContainer != null && !energyContainer.getNeeded().isZero() && WorldUtils.canSeeSun((Level)player.f_19853_, (BlockPos)(pos = new BlockPos(player.m_20185_(), player.m_20188_() + 0.2, player.m_20189_())))) {
            Biome b = (Biome)player.f_19853_.m_7062_().m_204214_(pos).m_203334_();
            boolean needsRainCheck = b.m_47530_() != Biome.Precipitation.NONE;
            float tempEff = 0.3f * (0.8f - b.m_47554_());
            tempEff = Math.max(tempEff, 0.0f);
            float humidityEff = needsRainCheck ? -0.3f * b.m_47548_() : 0.0f;
            FloatingLong peakOutput = ((FloatingLong)MekanismConfig.gear.mekaSuitSolarRechargingRate.get()).multiply((double)(1.0f + tempEff + humidityEff));
            float brightness = WorldUtils.getSunBrightness((Level)player.f_19853_, (float)1.0f);
            FloatingLong production = peakOutput.multiply((double)brightness);
            if (needsRainCheck && (player.f_19853_.m_46471_() || player.f_19853_.m_46470_())) {
                production = production.timesEqual(RAIN_MULTIPLIER);
            }
            energyContainer.insert(production.multiply((long)module.getInstalledCount()), Action.EXECUTE, AutomationType.MANUAL);
        }
    }
}

